<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              www.fln.com
 * @since             1.0.0
 * @package           Fln_Financial_Plugin
 *
 * @wordpress-plugin
 * Plugin Name:       Financial Plugin
 * Plugin URI:        www.fln.com
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Merxhan Emini
 * Author URI:        www.fln.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       fln-financial-plugin
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'PLUGIN_NAME_VERSION', '3.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-fln-financial-plugin-activator.php
 */
function activate_fln_financial_plugin() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-fln-financial-plugin-activator.php';
	Fln_Financial_Plugin_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-fln-financial-plugin-deactivator.php
 */
function deactivate_fln_financial_plugin() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-fln-financial-plugin-deactivator.php';
	Fln_Financial_Plugin_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_fln_financial_plugin' );
register_deactivation_hook( __FILE__, 'deactivate_fln_financial_plugin' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-fln-financial-plugin.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_fln_financial_plugin() {

	$plugin = new Fln_Financial_Plugin();
	$plugin->run();

}
run_fln_financial_plugin();
