<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       www.fln.com
 * @since      1.0.0
 *
 * @package    Fln_Financial_Plugin
 * @subpackage Fln_Financial_Plugin/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Fln_Financial_Plugin
 * @subpackage Fln_Financial_Plugin/admin
 * @author     Merxhan Emini <merxhan@blexr.com>
 */
class Fln_Financial_Plugin_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Fln_Financial_Plugin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Fln_Financial_Plugin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/fln-financial-plugin-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Fln_Financial_Plugin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Fln_Financial_Plugin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/fln-financial-plugin-admin.js', array( 'jquery' ), $this->version, false );

	}

	//Register Tables and Brokers post types
	public function cptui_register_my_cpts() {

	/**
	 * Post Type: Brokers.
	 */

	$labels = array(
		"name" => __( "Brokers", "financial_tables" ),
		"singular_name" => __( "Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "fln_broker", "with_front" => true ),
		"query_var" => true,
		"supports"	=> false,
		//"supports" => array( "title", "editor", "thumbnail" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "fln_broker", $args );

	/**
	 * Post Type: Tables.
	 */
	 // Register Custom Post Type


	 	$labels = array(
	 		'name'                  => _x( 'Tables', 'Post Type General Name', 'financial_tables' ),
	 		'singular_name'         => _x( 'Table', 'Post Type Singular Name', 'financial_tables' ),
	 		'menu_name'             => __( 'Tables', 'financial_tables' ),
	 		'name_admin_bar'        => __( 'Tables', 'financial_tables' ),
	 		'archives'              => __( 'Table Item Archives', 'financial_tables' ),
	 		'attributes'            => __( 'Table Item Attributes', 'financial_tables' ),
	 		'parent_item_colon'     => __( 'Parent Table:', 'financial_tables' ),
	 		'all_items'             => __( 'All Tables ', 'financial_tables' ),
	 		'add_new_item'          => __( 'Add New Table', 'financial_tables' ),
	 		'add_new'               => __( 'Add New Table', 'financial_tables' ),
	 		'new_item'              => __( 'New Table Item', 'financial_tables' ),
	 		'edit_item'             => __( 'Edit Table ', 'financial_tables' ),
	 		'update_item'           => __( 'Update Table ', 'financial_tables' ),
	 		'view_item'             => __( 'View Table ', 'financial_tables' ),
	 		'view_items'            => __( 'View Tables', 'financial_tables' ),
	 		'search_items'          => __( 'Search Tables', 'financial_tables' ),
	 		'not_found'             => __( 'Not found Table', 'financial_tables' ),
	 		'not_found_in_trash'    => __( 'Not found Table in Trash', 'financial_tables' ),
	 		'featured_image'        => __( 'Table Featured Image', 'financial_tables' ),
	 		'set_featured_image'    => __( 'Set Table featured image', 'financial_tables' ),
	 		'remove_featured_image' => __( 'Remove Table featured image', 'financial_tables' ),
	 		'use_featured_image'    => __( 'Use as Table featured image', 'financial_tables' ),
	 		'insert_into_item'      => __( 'Insert into Table', 'financial_tables' ),
	 		'uploaded_to_this_item' => __( 'Uploaded to this Table ', 'financial_tables' ),
	 		'items_list'            => __( 'Tables  list', 'financial_tables' ),
	 		'items_list_navigation' => __( 'Tables list navigation', 'financial_tables' ),
	 		'filter_items_list'     => __( 'Filter Tables list', 'financial_tables' ),
	 	);



	$args = array(
		"label" => __( "Tables", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "tables",
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "fln_table", "with_front" => true ),
		"query_var" => true,
		"supports" => array( "title", "editor", "thumbnail" ),
		"menu_icon" => 'dashicons-editor-table',
	);

	register_post_type( "fln_table", $args );


	/**
	 * Post Type: finance_api_main.
	 */

	$labels = array(
		"name" => __( "Main Brokers", "financial_tables" ),
		"singular_name" => __( "Main Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Main Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "main_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_main_broker", "with_front" => true ),
		"query_var" => true,
		// "supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_main", $args );


	/**
	* Post Type: finance_api_stocks.
	*/

	$labels = array(
		"name" => __( "Stocks Brokers", "financial_tables" ),
		"singular_name" => __( "Stocks Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Stocks Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "stocks_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_stocks_broker", "with_front" => true ),
		"query_var" => true,
		// "supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_stocks", $args );

		/**
	* Post Type: finance_api_cfd.
	*/

	$labels = array(
		"name" => __( "CFD Brokers", "financial_tables" ),
		"singular_name" => __( "CFD Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "CFD Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "cfd_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_cfd_broker", "with_front" => true ),
		"query_var" => true,
		//"supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_cfd", $args );
	
	/**
	* Post Type: finance_api_forex.
	*/

	$labels = array(
		"name" => __( "Forex Brokers", "financial_tables" ),
		"singular_name" => __( "Forex Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Forex Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "forex_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_forex_broker", "with_front" => true ),
		"query_var" => true,
		// "supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_forex", $args );

	/**
	* Post Type: finance_api_crypto.
	*/

	$labels = array(
		"name" => __( "Crypto Brokers", "financial_tables" ),
		"singular_name" => __( "Crypto Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Crypto Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "crypto_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_crypto_broker", "with_front" => true ),
		"query_var" => true,
		//"supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_crypto", $args );

	/**
	* Post Type: finance_api_commodities.
	*/

	$labels = array(
		"name" => __( "Commodities Brokers", "financial_tables" ),
		"singular_name" => __( "Commodities Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Commodities Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "commodities_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_commodities_broker", "with_front" => true ),
		"query_var" => true,
		// "supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_comm", $args );

	/**
	* Post Type: finance_api_discount.
	*/

	$labels = array(
		"name" => __( "Discount Brokers", "financial_tables" ),
		"singular_name" => __( "Discount Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Discount Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "discount_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_discount_broker", "with_front" => true ),
		"query_var" => true,
		// "supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_discount", $args );

	/**
	* Post Type: finance_api_social.
	*/

	$labels = array(
		"name" => __( "Social Brokers", "financial_tables" ),
		"singular_name" => __( "Social Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Social Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "social_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_social_broker", "with_front" => true ),
		"query_var" => true,
		//"supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_social", $args );

		/**
	* Post Type: finance_api_bonds.
	*/

	$labels = array(
		"name" => __( "Bonds Brokers", "financial_tables" ),
		"singular_name" => __( "Bonds Broker", "financial_tables" ),
	);

	$args = array(
		"label" => __( "Bonds Brokers", "financial_tables" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true, //changed to false defaults to true: hidden for quering
		"show_ui" => true,
		"show_in_rest" => true,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		"rest_base" => "bonds_brokers",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "finance_api_bonds_broker", "with_front" => true ),
		"query_var" => true,
		//"supports"	=> false,
		"supports" => array( "title" ),
		"menu_icon" => 'dashicons-chart-line'

	);

	register_post_type( "finance_api_bonds", $args );

}

public function cptui_register_my_taxes_table_cat() {

	/**
	 * Taxonomy: Table Categories.
	 */

	$labels = array(
		"name" => __( "Table Categories", "twentysixteen" ),
		"singular_name" => __( "Table Category", "twentysixteen" ),
		"menu_name" => __( "Table Categories", "twentysixteen" ),
		"all_items" => __( "All Table Categories", "twentysixteen" ),
		"edit_item" => __( "Edit Table Category", "twentysixteen" ),
		"view_item" => __( "View Table Category", "twentysixteen" ),
		"update_item" => __( "Update Table Category", "twentysixteen" ),
		"add_new_item" => __( "Add New Table Category", "twentysixteen" ),
		"new_item_name" => __( "New Table Category", "twentysixteen" ),
		"parent_item" => __( "Parent Table Category", "twentysixteen" ),
		"parent_item_colon" => __( "Parent Table Category Colon", "twentysixteen" ),
		"search_items" => __( "Search Table Categories", "twentysixteen" ),
		"popular_items" => __( "Popular Table Categories", "twentysixteen" ),
		"separate_items_with_commas" => __( "Separate Table Categories with Commas", "twentysixteen" ),
		"add_or_remove_items" => __( "Add or Remove Table Categories", "twentysixteen" ),
		"choose_from_most_used" => __( "Choose from Most Used Table Categories", "twentysixteen" ),
		"not_found" => __( "No Table Categories found", "twentysixteen" ),
		"no_terms" => __( "No Table Category", "twentysixteen" ),
		"items_list_navigation" => __( "Table Categories Navigation", "twentysixteen" ),
		"items_list" => __( "Table Categories List", "twentysixteen" ),
	);

	$args = array(
		"label" => __( "Table Categories", "twentysixteen" ),
		"labels" => $labels,
		"public" => true,
		"hierarchical" => true,
		"label" => "Table Categories",
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => array( 'slug' => 'table_cat', 'with_front' => true, ),
		"show_admin_column" => false,
		"show_in_rest" => false,
		"rest_base" => "",
		"show_in_quick_edit" => false,
	);
	register_taxonomy( "table_cat", array( "fln_table" ), $args );
}


public function acf_register_relationship_field() {
	//Relationship Field
	if(function_exists("register_field_group"))
	{
		register_field_group(array (
			'id' => 'acf_parent-child',
			'title' => 'Parent child',
			'fields' => array (
				array (
					'key' => 'field_5aad2a1a65303',
					'label' => 'Children',
					'name' => 'acf-children',
					'type' => 'relationship',
					'return_format' => 'object',
					'post_type' => array (
						0 => 'finance_api_stocks',
						1 => 'finance_api_forex',
						2 => 'finance_api_cfd',
						3 => 'finance_api_crypto',
						4 => 'finance_api_com',
						5 => 'finance_api_discount',
						6 => 'finance_api_social',
						7 => 'finance_api_bonds',
						8 => 'fln_broker',
					),
					'taxonomy' => array (
						0 => 'all',
					),
					'filters' => array (
						0 => 'search',
						1 => 'post_type',
					),
					'result_elements' => array (
						0 => 'post_type',
						1 => 'post_title',
					),
					'max' => '',
				),
			),
			'location' => array (
				array (
					array (
						'param' => 'post_type',
						'operator' => '==',
						'value' => 'fln_table',
						'order_no' => 0,
						'group_no' => 0,
					),
				),
			),
			'options' => array (
				'position' => 'normal',
				'layout' => 'no_box',
				'hide_on_screen' => array (
				),
			),
			'menu_order' => 0,
		));
	}

	// Relationship field between main and child profiles

	if(function_exists("register_field_group"))
	{
		register_field_group(array (
			'id' => 'api-main-child',
			'title' => 'Broker Main-Child',
			'fields' => array (
				array (
					'key' => 'api_main_5aad2a1a65303',
					'label' => 'Broker Children',
					'name' => 'broker-children',
					'type' => 'relationship',
					'return_format' => 'object',
					'post_type' => array (
						0 => 'finance_api_stocks',
						1 => 'finance_api_forex',
						2 => 'finance_api_cfd',
						3 => 'finance_api_crypto',
						4 => 'finance_api_com',
						5 => 'finance_api_discount',
						6 => 'finance_api_social',
						7 => 'finance_api_bonds',
					),
					'taxonomy' => array (
						0 => 'all',
					),
					'filters' => array (
						0 => 'search',
						1 => 'post_type',
					),
					'result_elements' => array (
						0 => 'post_type',
						1 => 'post_title',
					),
					'max' => '',
				),
			),
			'location' => array (
				array (
					array (
						'param' => 'post_type',
						'operator' => '==',
						'value' => 'finance_api_main',
						'order_no' => 0,
						'group_no' => 0,
					),
				),
			),
			'options' => array (
				'position' => 'normal',
				'layout' => 'no_box',
				'hide_on_screen' => array (
				),
			),
			'menu_order' => 0,
		));
	}

	// Relationship fields child to parent profile

	// Stocks relationship

	if(function_exists("register_field_group"))
	{
		register_field_group(array (
			'id' => 'api-stocks-parent',
			'title' => 'Main profile',
			'fields' => array (
				array (
					'key' => 'api_stocks_5aad2a1a65303',
					'label' => 'Choose parent broker profile',
					'name' => 'broker-children',
					'type' => 'relationship',
					'return_format' => 'object',
					'post_type' => array (
						0 => 'finance_api_main',
					),
					'taxonomy' => array (
						0 => 'all',
					),
					'filters' => array (
						0 => 'search',
						1 => 'post_type',
					),
					'result_elements' => array (
						0 => 'post_type',
						1 => 'post_title',
					),
					'required' => 1,
					'max' => 1,
				),
			),
			'location' => array (
				array (
					array (
						'param' => 'post_type',
						'operator' => '==',
						'value' => 'finance_api_stocks',
						'order_no' => 0,
						'group_no' => 0,
					),
				),
			),
			'options' => array (
				'position' => 'normal',
				'layout' => 'no_box',
				'hide_on_screen' => array (
				),
			),
			'menu_order' => 0,
		));
	}

	// Forex relationship

	if(function_exists("register_field_group"))
	{
		register_field_group(array (
			'id' => 'api-forex-parent',
			'title' => 'Main profile',
			'fields' => array (
				array (
					'key' => 'api_forex_5aad2a1a65303',
					'label' => 'Choose parent broker profile',
					'name' => 'broker-children',
					'type' => 'relationship',
					'return_format' => 'object',
					'post_type' => array (
						0 => 'finance_api_main',
					),
					'taxonomy' => array (
						0 => 'all',
					),
					'filters' => array (
						0 => 'search',
						1 => 'post_type',
					),
					'result_elements' => array (
						0 => 'post_type',
						1 => 'post_title',
					),
					'required' => 1,
					'max' => 1,
				),
			),
			'location' => array (
				array (
					array (
						'param' => 'post_type',
						'operator' => '==',
						'value' => 'finance_api_forex',
						'order_no' => 0,
						'group_no' => 0,
					),
				),
			),
			'options' => array (
				'position' => 'normal',
				'layout' => 'no_box',
				'hide_on_screen' => array (
				),
			),
			'menu_order' => 0,
		));
	}

		// CFDs relationship

		if(function_exists("register_field_group"))
		{
			register_field_group(array (
				'id' => 'api-cfd-parent',
				'title' => 'Main profile',
				'fields' => array (
					array (
						'key' => 'api_cfd_5aad2a1a65303',
						'label' => 'Choose parent broker profile',
						'name' => 'broker-children',
						'type' => 'relationship',
						'return_format' => 'object',
						'post_type' => array (
							0 => 'finance_api_main',
						),
						'taxonomy' => array (
							0 => 'all',
						),
						'filters' => array (
							0 => 'search',
							1 => 'post_type',
						),
						'result_elements' => array (
							0 => 'post_type',
							1 => 'post_title',
						),
						'required' => 1,
						'max' => 1,
					),
				),
				'location' => array (
					array (
						array (
							'param' => 'post_type',
							'operator' => '==',
							'value' => 'finance_api_cfd',
							'order_no' => 0,
							'group_no' => 0,
						),
					),
				),
				'options' => array (
					'position' => 'normal',
					'layout' => 'no_box',
					'hide_on_screen' => array (
					),
				),
				'menu_order' => 0,
			));
		}

		// Crypto relationship

		if(function_exists("register_field_group"))
		{
			register_field_group(array (
				'id' => 'api-crypto-parent',
				'title' => 'Main profile',
				'fields' => array (
					array (
						'key' => 'api_crypto_5aad2a1a65303',
						'label' => 'Choose parent broker profile',
						'name' => 'broker-children',
						'type' => 'relationship',
						'return_format' => 'object',
						'post_type' => array (
							0 => 'finance_api_main',
						),
						'taxonomy' => array (
							0 => 'all',
						),
						'filters' => array (
							0 => 'search',
							1 => 'post_type',
						),
						'result_elements' => array (
							0 => 'post_type',
							1 => 'post_title',
						),
						'required' => 1,
						'max' => 1,
					),
				),
				'location' => array (
					array (
						array (
							'param' => 'post_type',
							'operator' => '==',
							'value' => 'finance_api_crypto',
							'order_no' => 0,
							'group_no' => 0,
						),
					),
				),
				'options' => array (
					'position' => 'normal',
					'layout' => 'no_box',
					'hide_on_screen' => array (
					),
				),
				'menu_order' => 0,
			));
		}

		// Discound relationship

		if(function_exists("register_field_group"))
		{
			register_field_group(array (
				'id' => 'api-discount-parent',
				'title' => 'Main profile',
				'fields' => array (
					array (
						'key' => 'api_discount_5aad2a1a65303',
						'label' => 'Choose parent broker profile',
						'name' => 'broker-children',
						'type' => 'relationship',
						'return_format' => 'object',
						'post_type' => array (
							0 => 'finance_api_main',
						),
						'taxonomy' => array (
							0 => 'all',
						),
						'filters' => array (
							0 => 'search',
							1 => 'post_type',
						),
						'result_elements' => array (
							0 => 'post_type',
							1 => 'post_title',
						),
						'required' => 1,
						'max' => 1,
					),
				),
				'location' => array (
					array (
						array (
							'param' => 'post_type',
							'operator' => '==',
							'value' => 'finance_api_discount',
							'order_no' => 0,
							'group_no' => 0,
						),
					),
				),
				'options' => array (
					'position' => 'normal',
					'layout' => 'no_box',
					'hide_on_screen' => array (
					),
				),
				'menu_order' => 0,
			));
		}

		// Social relationship

		if(function_exists("register_field_group"))
		{
			register_field_group(array (
				'id' => 'api-social-parent',
				'title' => 'Main profile',
				'fields' => array (
					array (
						'key' => 'api_social_5aad2a1a65303',
						'label' => 'Choose parent broker profile',
						'name' => 'broker-children',
						'type' => 'relationship',
						'return_format' => 'object',
						'post_type' => array (
							0 => 'finance_api_main',
						),
						'taxonomy' => array (
							0 => 'all',
						),
						'filters' => array (
							0 => 'search',
							1 => 'post_type',
						),
						'result_elements' => array (
							0 => 'post_type',
							1 => 'post_title',
						),
						'required' => 1,
						'max' => 1,
					),
				),
				'location' => array (
					array (
						array (
							'param' => 'post_type',
							'operator' => '==',
							'value' => 'finance_api_social',
							'order_no' => 0,
							'group_no' => 0,
						),
					),
				),
				'options' => array (
					'position' => 'normal',
					'layout' => 'no_box',
					'hide_on_screen' => array (
					),
				),
				'menu_order' => 0,
			));
		}

		// Bonds relationship

		if(function_exists("register_field_group"))
		{
			register_field_group(array (
				'id' => 'api-bonds-parent',
				'title' => 'Main profile',
				'fields' => array (
					array (
						'key' => 'api_bonds_5aad2a1a65303',
						'label' => 'Choose parent broker profile',
						'name' => 'broker-children',
						'type' => 'relationship',
						'return_format' => 'object',
						'post_type' => array (
							0 => 'finance_api_main',
						),
						'taxonomy' => array (
							0 => 'all',
						),
						'filters' => array (
							0 => 'search',
							1 => 'post_type',
						),
						'result_elements' => array (
							0 => 'post_type',
							1 => 'post_title',
						),
						'required' => 1,
						'max' => 1,
					),
				),
				'location' => array (
					array (
						array (
							'param' => 'post_type',
							'operator' => '==',
							'value' => 'finance_api_bonds',
							'order_no' => 0,
							'group_no' => 0,
						),
					),
				),
				'options' => array (
					'position' => 'normal',
					'layout' => 'no_box',
					'hide_on_screen' => array (
					),
				),
				'menu_order' => 0,
			));
		}


		// Commodities relationship

		if(function_exists("register_field_group"))
		{
			register_field_group(array (
				'id' => 'api-commodities-parent',
				'title' => 'Main profile',
				'fields' => array (
					array (
						'key' => 'api_commodities_5aad2a1a65303',
						'label' => 'Choose parent broker profile',
						'name' => 'broker-children',
						'type' => 'relationship',
						'return_format' => 'object',
						'post_type' => array (
							0 => 'finance_api_main',
						),
						'taxonomy' => array (
							0 => 'all',
						),
						'filters' => array (
							0 => 'search',
							1 => 'post_type',
						),
						'result_elements' => array (
							0 => 'post_type',
							1 => 'post_title',
						),
						'required' => 1,
						'max' => 1,
					),
				),
				'location' => array (
					array (
						array (
							'param' => 'post_type',
							'operator' => '==',
							'value' => 'finance_api_comm',
							'order_no' => 0,
							'group_no' => 0,
						),
					),
				),
				'options' => array (
					'position' => 'normal',
					'layout' => 'no_box',
					'hide_on_screen' => array (
					),
				),
				'menu_order' => 0,
			));
		}


}
/**
 *  Register custom fields for broker
 */
public function acf_register_broker_fields() {

$regions_array = array();

if (function_exists('geot_country_regions')) {

	$regions_list = array_map(
		function($region) { return $region['name']; },
		geot_country_regions()
	);

	foreach( $regions_list as $region) {
		$regions_array[$region] = $region;
	}

}


// Register fields for fln_broker post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'acf_broker-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'field_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
			),
			array(
				'key'           => 'field_59ef13e48f496',
				'label'         => 'Name of the Broker',
				'name'          => 'fln_broker_name',
				'type'          => 'text',
				'instructions'  => 'Please give the name of the broker (max characters 100). Field name: fln_broker_name',
				'required'      => 1,
				'default_value' => 'N/A',
				'placeholder'   => 'ex. 1000 Extra',
				'prepend'       => '',
				'append'        => '',
				'formatting'    => 'html',
				'maxlength'     => 100,
			),
			array (
				'key' => 'field_94g3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fln_main_broker',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fln_main_broker',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_253ffca1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fln_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fln_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5db555594ce92',
				'label' => 'Currency',
				'name' => 'fln_deposit_currency',
				'type' => 'radio',
				'instructions' => 'Select one that apply. Field name: fln_deposit_currency',
				'choices' => array (
					'&dollar;' => 'USD',
					'&euro;' => 'EUR',
					'&pound;' => 'GBP',
				),
				'default_value' => '0: &dollar;',
				'layout' => 'vertical',
			),
			array(
				'key'           => 'field_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fln_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fln_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
				'prepend'       => '',
				'append'        => '',
				'min'           => '',
				'max'           => '',
				'step'          => '',
			),
			array(
				'key'           => 'field_59jb513c8cb87',
				'label'         => 'Welcome Bonus Tooltip',
				'name'          => 'fln_welcome_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fln_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
				'prepend'       => '',
				'append'        => '',
				'min'           => '',
				'max'           => '',
				'step'          => '',
			),
			array(
				'key'           => 'field_59ef21808cb89',
				'label'         => 'Broker Category',
				'name'              => 'fln_broker_category',
				'type' => 'radio',
				'choices' => array (
					'forex' => 'Forex',
					'new_forex' => 'New forex',
				),
				'instructions'   => 'Please choose category for hidden fields. Field name: fln_broker_category',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array(
				'key'           => 'field_59ef232d0245e',
				'label'         => 'Brokers Review Link Default',
				'name'          => 'fln_review',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the broker\'s review url as:  http://www.example.com -- this link will be used if others not found. Field name: fln_review',
				'placeholder'   => 'http://www.example.com',
				'prepend'       => '',
				'append'        => '',
				'formatting'    => 'html',
				'maxlength'     => '',
			),
			array(
				'key'           => 'field_59ef232d0245f',
				'label'         => 'Brokers Review Link TRFB (TopRatedForexBrokers.com)',
				'name'          => 'fln_review_trfb',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the broker\'s review url as:  http://www.example.com. Field name: fln_review_trfb',
				'placeholder'   => 'http://www.example.com',
				'prepend'       => '',
				'append'        => '',
				'formatting'    => 'html',
				'maxlength'     => '',
			),
			array(
				'key'           => 'field_59ef232d0245g',
				'label'         => 'Brokers Review Link TOFB (TopOnlineForexBrokers.com)',
				'name'          => 'fln_review_tofb',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the broker\'s review url as:  http://www.example.com. Field name: fln_review_tofb',
				'placeholder'   => 'http://www.example.com',
				'prepend'       => '',
				'append'        => '',
				'formatting'    => 'html',
				'maxlength'     => '',
			),
			array (
				'key' => 'field_5a0b0f773723d',
				'label' => 'Button Link Default',
				'name' => 'fln_button_link',
				'type' => 'text',
				'instructions' => 'Please provide the url of the button link as /go/broker_name/ -- this link will be used if others not found. Field name: fln_button_link',
				'placeholder' => '/go/broker_name/',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5a0b0f773723e',
				'label' => 'Button Link for TRFB (TopRatedForexBrokers.com)',
				'name' => 'fln_button_link_trfb',
				'type' => 'text',
				'instructions' => 'Please provide the url of the button link as /go/broker_name/. Field name: fln_button_link_trfb',
				'placeholder' => '/go/broker_name/',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5a0b0f773723f',
				'label' => 'Button Link for TOFB (TopOnlineForexBrokers.com)',
				'name' => 'fln_button_link_tofb',
				'type' => 'text',
				'instructions' => 'Please provide the url of the button link as /go/broker_name/. Field name: fln_button_link_tofb',
				'placeholder' => '/go/broker_name/',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5db84209j4e94',
				'label' => 'Private platform',
				'name' => 'fln_private_platform',
				'type' => 'text',
				'instructions' => 'If private trading platform is selected, specify text. Field name: fln_private_platform',
				'default_value' => '',
				'placeholder' => 'The name/text for tooltip',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5db8420d4ce94',
				'label' => 'Customer support',
				'name' => 'fln_customer_support',
				'type' => 'text',
				'instructions' => '24/5, 24/7, else? Field name: fln_customer_support',
				'default_value' => 'N/A',
				'placeholder' => 'Ex. 24/7',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5db8425a4ce95',
				'label' => 'Used by',
				'name' => 'fln_used_by',
				'type' => 'text',
				'instructions' => 'Insert only number part. Field name: fln_used_by',
				'default_value' => '100,000+',
				'placeholder' => 'Ex. 230,000+',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fln_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fln_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'field_5db843e24ce8f',
				'label' => 'Language Support',
				'name' => 'fln_language_support',
				'type' => 'number',
				'instructions' => 'Specify number of supported languages. Field name: fln_language_support',
				'default_value' => '1',
				'placeholder' => 'Ex. 5',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_5db843e24bg8f',
				'label' => 'Established',
				'name' => 'fln_established',
				'type' => 'text',
				'instructions' => 'Specify number of supported languages. Field name: fln_established',
				'default_value' => '-',
				'placeholder' => 'Ex. 2002, HQ in UK',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5a0079f1c7ec4',
				'label' => 'Broker\'s Logo',
				'name' => 'fln_brokers_logo',
				'type' => 'image',

				'instructions' => 'Please provide the broker\'s logo. Field name: fln_brokers_logo',
				'default_value' => '',

				'save_format' => 'object',
				'preview_size' => 'medium',
				'library' => 'all',
			),
			array (
				'key' => 'field_5db841644ce92',
				'label' => 'Geotargeting regions',
				'name' => 'fln_geotargeting_regions',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fln_geotargeting_regions',
				'choices' => $regions_array,
				'default_value' => '',
				'layout' => 'vertical',
			),
			array (
				'key' => 'field_5db841644ck52',
				'label' => 'User experience',
				'name' => 'fln_user_experience',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fln_user_experience',
				'choices' => array (
					'Beginner' => 'Beginner',
					'Intermediate' => 'Intermediate',
					'Professional' => 'Professional',
				),
				'default_value' => '',
				'layout' => 'vertical',
			),
			array (
				'key' => 'field_5a20247d48a40',
				'label' => 'Device Platforms',
				'name' => 'fln_device_platforms',
				'type' => 'select',
				'instructions' => 'Please select the available broker\'s platforms (multiple values). Field name: fln_device_platforms',
				'choices' => array (
					'PC' => 'PC',
					'Android' => 'Android',
					'iOS' => 'iOS',
				),
				'default_value' => '0: PC',
				'allow_null' => 0,
				'multiple' => 1,
			),
			array (
				'key' => 'field_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
			),
			array(
				'key'               => 'field_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fln_rating',
				'type'              => 'radio',
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fln_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'field_5db843e24ce96',
				'label' => 'Points rating',
				'name' => 'fln_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). Field name: fln_points_rating',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'field_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fln_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fln_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'field_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fln_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fln_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'field_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fln_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fln_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'field_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fln_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fln_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'field_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fln_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fln_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'field_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fln_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fln_education_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'field_5eb3fc5ffbd52',
				'label' => 'Broker Summary',
				'name' => '',
				'type' => 'tab',
			),
			array(
				'key'           => 'field_59ef20e640495',
				'label'         => 'Min. Deposit (Amount)',
				'name'          => 'fln_min_deposit',
				'type'          => 'text',
				'default_value' => '-',
				'instructions'   => 'Please insert the amount of money - no currency symbols required. Field name: fln_min_deposit',
				'placeholder'   => 'ex. 250',
				'prepend'       => '',
				'append'        => '',
			),
			array (
				'key' => 'field_5db841594ce92',
				'label' => 'Regulators',
				'name' => 'fln_regulators',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fln_regulators',
				'choices' => array (
					'FCA' => 'FCA',
					'CySec' => 'CySec',
					'FSCA' => 'FSCA',
					'ASIC' => 'ASIC',
					'CIMA' => 'CIMA',
					'IFSC' => 'IFSC',
					'IIROC' => 'IIROC',
					'FSA(SVG)' => 'FSA (SVG)',
					'FSC' => 'FSC',
				),
				'default_value' => 'FCA',
				'layout' => 'vertical',
			),
			array(
				'key'           => 'field_52fc14678f497',
				'label'         => 'Other regulator',
				'name'          => 'fln_regulators_other',
				'type'          => 'text',
				'default_value' => '-',
				'instructions'   => 'Please insert the value of other regulator. Field name: fln_regulators_other',
				'placeholder'   => 'ex. MAS ',
				'prepend'       => '',
				'append'        => '',
			),
			array(
				'key'           => 'field_59ef14678f497',
				'label'         => 'Max Leverage',
				'name'          => 'fln_max_leverage',
				'type'          => 'text',
				'default_value' => '-',
				'instructions'   => 'Please insert the value of leverage. Field name: fln_max_leverage',
				'placeholder'   => 'ex. 1:30 ',
				'prepend'       => '',
				'append'        => '',
			),
			array (
				'key' => 'field_6fc3fca1fbd55',
				'label' => 'Client Protection',
				'name' => 'fln_client_protection',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fln_client_protection',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5db841234ce90',
				'label' => 'Type of Brokers',
				'name' => 'fln_type_of_brokers',
				'type' => 'text',
				'instructions' => 'Specify type of the broker. Field name: fln_type_of_brokers',
				'default_value' => 'Market Maker',
				'placeholder' => 'ex. Market Maker',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5db8408c4ce8f',
				'label' => 'Trading instruments',
				'name' => 'fln_trading_instruments',
				'type' => 'text',
				'instructions' => 'A number of trading instruments. Field name: fln_trading_instruments',
				'default_value' => '',
				'placeholder' => 'ex. 1000+',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5db841da4ce93',
				'label' => 'Currency Pairs',
				'name' => 'fln_currency_pairs',
				'type' => 'text',
				'instructions' => 'A number of currency pairs. Field name: fln_currency_pairs',
				'default_value' => 'N/A',
				'placeholder' => 'Ex. 59+',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_5eb3fc85fbd53',
				'label' => 'Stocks',
				'name' => 'fln_stocks',
				'type' => 'text',
				'instructions' => 'A number of stocks. Field name: fln_stocks',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fc93fbd54',
				'label' => 'Cryptocurrencies',
				'name' => 'fln_cryptocurrencies_number',
				'type' => 'text',
				'instructions' => 'A number of stocks. Field name: fln_cryptocurrencies_number',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fca1fbd55',
				'label' => 'CFDs',
				'name' => 'fln_cfds',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_cfds',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5db841655ce92',
				'label' => 'Trading platforms',
				'name' => 'fln_trading_platforms',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fln_trading_platforms',
				'choices' => array (
					'MT4' => 'MT4',
					'MT5' => 'MT5',
					'mobile' => 'Mobile App',
					'WebTrader' => 'WebTrader',
					'cTrader' => 'cTrader',
					'Private' => 'Private',
				),
				'default_value' => 'MT4',
				'layout' => 'vertical',
			),
			array (
				'key' => 'field_5eb3fccdfbd56',
				'label' => 'Research Tools',
				'name' => 'fln_research_tools',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_research_tools',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb3fcdefbd57',
				'label' => 'Educational Materials',
				'name' => 'fln_educational_materials',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_educational_materials',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5db8414f4ce91',
				'label' => 'Deposit methods',
				'name' => 'fln_deposit_methods',
				'type' => 'text',
				'instructions' => 'Type deposit methods that apply here. Field name: fln_deposit_methods',
				'default_value' => 'Bank Transfer',
				'placeholder' => 'ex. Bank Transfer, Visa',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5db8420d4ce94',
				'label' => 'Customer support',
				'name' => 'fln_customer_support',
				'type' => 'text',
				'instructions' => '24/5, 24/7, else? Field name: fln_customer_support',
				'default_value' => 'N/A',
				'placeholder' => 'Ex. 24/7',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5eb3fcf7fbd58',
				'label' => 'Live Chat',
				'name' => 'fln_live_chat',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_live_chat',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb3fd42fbd59',
				'label' => 'Fees',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5a0b0e7af104f',
				'label' => 'Min. Spread',
				'name' => 'fln_min_spread',
				'type' => 'text',
				'instructions' => 'Please provide the amount of Minimum Spread (pips). Field name: fln_min_spread',
				'default_value' => '-',
				'placeholder' => 'ex 0,5',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fd84fbd5a',
				'label' => 'Commission',
				'name' => 'fln_commission',
				'type' => 'text',
				'instructions' => 'Value in %. Field name: fln_commission',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_5eb3fd98fbd5b',
				'label' => 'Commission on Islamic Accounts',
				'name' => 'commission_on_islamic_accounts',
				'type' => 'text',
				'instructions' => 'Value in %. Field name: commission_on_islamic_accounts',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5eb3fdb4fbd5c',
				'label' => 'Account Fee',
				'name' => 'fln_account_fee',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_account_fee',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb3fdbffbd5d',
				'label' => 'Inactivity Fees',
				'name' => 'fln_inactivity_fees',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_inactivity_fees',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb3fdccfbd5e',
				'label' => 'Deposit Fees',
				'name' => 'fln_deposit_fees',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_deposit_fees',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb3fddefbd5f',
				'label' => 'Withdrawal Fees',
				'name' => 'fln_withdrawal_fees',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_withdrawal_fees',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb3fdfefbd60',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5eb3fe0ffbd61',
				'label' => 'Commodities',
				'name' => 'fln_commodities',
				'type' => 'text',
				'instructions' => 'Number of commodities. Field name: fln_commodities',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fe0jkvd61',
				'label' => 'Options',
				'name' => 'fln_options',
				'type' => 'text',
				'instructions' => 'Number of options. Field name: fln_options',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fe1efbd62',
				'label' => 'Precious Metals',
				'name' => 'fln_precious_metals',
				'type' => 'text',
				'instructions' => 'Number of precious metals. Field name: fln_precious_metals',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fe33fbd63',
				'label' => 'Indices',
				'name' => 'fln_indices',
				'type' => 'text',
				'instructions' => 'Number of indices. Field name: fln_indices',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fe3afbd64',
				'label' => 'Stocks and Shares',
				'name' => 'fln_stocks_and_shares',
				'type' => 'number',
				'instructions' => 'Number of stocks and shares. Field name: fln_stocks_and_shares',
				'default_value' => 0,
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fe4efbd65',
				'label' => 'Cryptocurrencies',
				'name' => 'fln_cryptocurrencies',
				'type' => 'text',
				'instructions' => 'Number of cryptocurrencies. Field name: fln_cryptocurrencies',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3fed5fbd66',
				'label' => 'ETFs',
				'name' => 'fln_etfs',
				'type' => 'text',
				'instructions' => 'Number of cryptocurrencies. Field name: fln_etfs',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'field_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5eb41af317944',
				'label' => 'News',
				'name' => 'fln_news',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_news',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b1317945',
				'label' => 'Trading Signals and Indicators',
				'name' => 'fln_trading_signals_and_indicators',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_trading_signals_and_indicators',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b2717946',
				'label' => 'Trade Ideas',
				'name' => 'fln_trade_ideas',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_trade_ideas',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b3017947',
				'label' => 'Expert Analysis',
				'name' => 'fln_expert_analysis',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_expert_analysis',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b3e17948',
				'label' => 'Autochartist Tools',
				'name' => 'fln_autochartist_tools',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_autochartist_tools',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b4c17949',
				'label' => 'Sentiment Charts',
				'name' => 'fln_sentiment_charts',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_sentiment_charts',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fln_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b611794b',
				'label' => 'Educational Features',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5eb41b6b1794c',
				'label' => 'Demo Account',
				'name' => 'fln_demo_account',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_demo_account',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b761794d',
				'label' => 'Platform Tutorial Videos',
				'name' => 'fln_platform_tutorial_videos',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_platform_tutorial_videos',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b831794e',
				'label' => 'Educational PDFs',
				'name' => 'fln_educational_pdfs',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_educational_pdfs',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b8e1794f',
				'label' => 'Live Webinars',
				'name' => 'fln_live_webinars',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_live_webinars',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41b9717950',
				'label' => 'YouTube Videos',
				'name' => 'fln_youtube_videos',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_youtube_videos',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41ba817951',
				'label' => 'Trading Academy',
				'name' => 'fln_trading_academy',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_trading_academy',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5eb41bb517952',
				'label' => 'Trading Glossary',
				'name' => 'fln_trading_glossary',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fln_trading_glossary',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'fln_broker',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_main_broker post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-main-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_main_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
			),
			array(
				'key'           => 'api_main_96cf13e48f496',
				'label'         => 'Name of the Broker',
				'name'          => 'fapi_broker_name',
				'type'          => 'text',
				'instructions'  => 'Please give the name of the broker (max characters 100). Field name: fapi_broker_name',
				'required'      => 1,
				'default_value' => 'N/A',
				'placeholder'   => 'ex. 1000 Extra',
				'prepend'       => '',
				'append'        => '',
				'formatting'    => 'html',
				'maxlength'     => 100,
			),
			array (
				'key' => 'api_main_5db555594ce92',
				'label' => 'Currency',
				'name' => 'fapi_main_deposit_currency',
				'type' => 'radio',
				'instructions' => 'Select one that apply. Field name: fapi_main_deposit_currency',
				'choices' => array (
					'&dollar;' => 'USD',
					'&euro;' => 'EUR',
					'&pound;' => 'GBP',
				),
				'default_value' => '0: &dollar;',
				'layout' => 'vertical',
			),
			array (
				'key' => 'api_main_5db84209j4e94',
				'label' => 'Private platform',
				'name' => 'fapi_main_private_platform',
				'type' => 'text',
				'instructions' => 'If private trading platform is selected, specify text. Field name: fapi_main_private_platform',
				'default_value' => '',
				'placeholder' => 'The name/text for tooltip',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5db8420d4ce94',
				'label' => 'Customer support',
				'name' => 'fapi_main_customer_support',
				'type' => 'text',
				'instructions' => '24/5, 24/7, else? Field name: fapi_main_customer_support',
				'default_value' => 'N/A',
				'placeholder' => 'Ex. 24/7',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5db8425a4ce95',
				'label' => 'Used by',
				'name' => 'fapi_main_used_by',
				'type' => 'text',
				'instructions' => 'Insert only number part. Field name: fapi_main_used_by',
				'default_value' => '',
				'placeholder' => 'Ex. 230,000+',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5db843e24ce8f',
				'label' => 'Language Support',
				'name' => 'fapi_main_language_support',
				'type' => 'number',
				'instructions' => 'Specify number of supported languages. Field name: fapi_main_language_support',
				'default_value' => '1',
				'placeholder' => 'Ex. 5',
				'prepend' => '',
				'append' => '',
				'min' => '1',
				'max' => '',
				'step' => '1',
			),
			array (
				'key' => 'api_main_5db843e24bg8f',
				'label' => 'Established',
				'name' => 'fapi_main_established',
				'type' => 'text',
				'instructions' => 'Specify number of supported languages. Field name: fapi_main_established',
				'default_value' => '-',
				'placeholder' => 'Ex. 2002, HQ in UK',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5a0079f1c7ec4',
				'label' => 'Broker\'s Logo',
				'name' => 'fapi_main_broker_logo',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Please provide the broker\'s logo. Field name: fapi_main_broker_logo',
			),
			array (
				'key' => 'api_main_5db841644ce92',
				'label' => 'Geotargeting regions',
				'name' => 'fapi_geotargeting_regions',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fapi_geotargeting_regions',
				'choices' => $regions_array,
				'default_value' => '',
				'layout' => 'vertical',
			),
			array (
				'key' => 'api_main_5db841644ck52',
				'label' => 'User experience',
				'name' => 'fapi_main_user_experience',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fapi_main_user_experience',
				'choices' => array (
					'Beginner' => 'Beginner',
					'Intermediate' => 'Intermediate',
					'Professional' => 'Professional',
				),
				'default_value' => '',
				'layout' => 'vertical',
			),
			array (
				'key' => 'api_main_5a20247d48a40',
				'label' => 'Device Platforms',
				'name' => 'fapi_main_device_platforms',
				'type' => 'checkbox',
				'instructions' => 'Please select the available broker\'s platforms (multiple values). Field name: fapi_main_device_platforms',
				'choices' => array (
					'PC' => 'PC',
					'Android' => 'Android',
					'iOS' => 'iOS',
					'Mac' => 'Mac'
				),
				'default_value' => '0: PC',
				'allow_null' => 0,
				'multiple' => 1,
			),
			array (
				'key' => 'api_main_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_main_63f3fbc2fbd4c',
				'label' => 'Overall score',
				'name' => 'fapi_main_overall_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_main_overall_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_main_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_main_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_main_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_main_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_main_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_main_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_main_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_main_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_main_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_main_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_main_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_main_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_main_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_main_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_main_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_main_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_main_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_main_education_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_main_5eb3fc5bb9d52',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_main_5eb3fe0ffbd61',
				'label' => 'Commodities',
				'name' => 'fapi_main_commodities',
				'type' => 'text',
				'instructions' => 'Number of commodities. Field name: fapi_main_commodities',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_main_5eb3fe0jkvd61',
				'label' => 'Options',
				'name' => 'fapi_main_options',
				'type' => 'text',
				'instructions' => 'Number of options. Field name: fapi_main_options',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_main_5eb3fe33fbd63',
				'label' => 'Indices',
				'name' => 'fapi_main_indices',
				'type' => 'text',
				'instructions' => 'Number of indices. Field name: fapi_main_indices',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_main_5eb3fe3afbd64',
				'label' => 'Stocks and Shares',
				'name' => 'fapi_main_stocks_and_shares',
				'type' => 'text',
				'instructions' => 'Number of stocks and shares. Field name: fapi_main_stocks_and_shares',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_main_5eb3fe4efbd65',
				'label' => 'Cryptocurrencies',
				'name' => 'fapi_main_cryptocurrencies',
				'type' => 'text',
				'instructions' => 'Number of cryptocurrencies. Field name: fapi_main_cryptocurrencies',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_main_5eb3fca1fbd55',
				'label' => 'CFDs',
				'name' => 'fapi_main_cfds',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_cfds',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb3fc5ffbd52',
				'label' => 'Broker Summary',
				'name' => '',
				'type' => 'tab',
			),
			array(
				'key'           => 'api_main_59ef20e640495',
				'label'         => 'Min. Deposit (Amount)',
				'name'          => 'fapi_main_min_deposit',
				'type'          => 'text',
				'required' => 1,
				'default_value' => '-',
				'instructions'   => 'Please insert the amount of money - no currency symbols required. Field name: fapi_main_min_deposit',
				'placeholder'   => 'ex. 250',
				'prepend'       => '',
				'append'        => '',
			),
			array (
				'key' => 'api_main_5db841594ce92',
				'label' => 'Regulators',
				'name' => 'fapi_main_regulators',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fapi_main_regulators',
				'choices' => array (
					'FCA' => 'FCA',
					'CySec' => 'CySec',
					'FSCA' => 'FSCA',
					'ASIC' => 'ASIC',
					'CIMA' => 'CIMA',
					'IFSC' => 'IFSC',
					'IIROC' => 'IIROC',
					'FSA(SVG)' => 'FSA (SVG)',
					'FSC' => 'FSC',
					'SIPC' => 'SIPC',
					'FINRA' => 'FINRA'
				),
				'default_value' => '',
				'layout' => 'vertical',
			),
			array(
				'key'           => 'api_main_52fc14678f497',
				'label'         => 'Other regulator',
				'name'          => 'fapi_main_regulators_other',
				'type'          => 'text',
				'default_value' => '-',
				'instructions'   => 'Please insert the value of other regulator. Field name: fapi_main_regulators_other',
				'placeholder'   => 'ex. MAS ',
				'prepend'       => '',
				'append'        => '',
			),
			array (
				'key' => 'api_main_6fc3fca1fbd55',
				'label' => 'Client Protection',
				'name' => 'fapi_main_client_protection',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_main_client_protection',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5db841234ce90',
				'label' => 'Type of Broker',
				'name' => 'fapi_main_type_of_broker',
				'type' => 'text',
				'instructions' => 'Specify type of the broker. Field name: fapi_main_type_of_broker',
				'default_value' => 'Market Maker',
				'placeholder' => 'ex. Market Maker',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5db8408c4ce8f',
				'label' => 'Trading instruments',
				'name' => 'fapi_main_trading_instruments',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'A number of trading instruments. Field name: fapi_main_trading_instruments',
				'default_value' => '',
				'placeholder' => 'ex. 1000+',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5db841655ce92',
				'label' => 'Trading platforms',
				'name' => 'fapi_main_trading_platforms',
				'type' => 'checkbox',
				'instructions' => 'Select all that apply. Field name: fapi_main_trading_platforms',
				'choices' => array (
					'MT4' => 'MT4',
					'MT5' => 'MT5',
					'mobile' => 'Mobile App',
					'WebTrader' => 'WebTrader',
					'cTrader' => 'cTrader',
					'Private' => 'Private',
				),
				'default_value' => '',
				'layout' => 'vertical',
			),
			array (
				'key' => 'api_main_5dbvg4655ce92',
				'label' => 'Markets and products',
				'name' => 'fapi_main_markets_products_list',
				'type' => 'checkbox',
				'required' => 1,
				'instructions' => 'Select all that apply. Field name: fapi_main_markets_products_list',
				'choices' => array (
					'Stock',
					'Forex',
					'CFD',
					'Crypto',
					'Commodities',
					'Discount',
					'Social',
					'Bonds'
				),
				'default_value' => '',
				'layout' => 'vertical',
			),
			array (
				'key' => 'api_main_6fg3fyybfbd56',
				'label' => 'Proprietary Trading Platform',
				'name' => 'fapi_main_proprietary_platform',
				'type' => 'radio',
				'choices' => array(
					0 => 'No',
					1 => 'Yes'
				),
				'required' => 1,
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_proprietary_platform',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb3fyybfbd56',
				'label' => 'Mobile compatible',
				'name' => 'fapi_main_mobile_compatible',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_mobile_compatible',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb3fccdfbd56',
				'label' => 'Research Tools',
				'name' => 'fapi_main_research_tools',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_research_tools',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb3fcdefbd57',
				'label' => 'Educational Materials',
				'name' => 'fapi_main_educational_materials',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_educational_materials',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5db8414f4ce91',
				'label' => 'Payment Methods',
				'name' => 'fapi_main_payment_methods',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Type deposit methods that apply here. Field name: fapi_main_deposit_methods',
				'default_value' => 'Bank Transfer',
				'placeholder' => 'ex. Bank Transfer, Visa',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5db8420d4ce94',
				'label' => 'Customer support',
				'name' => 'fapi_main_customer_support',
				'type' => 'text',
				'required' => 1,
				'instructions' => '24/5, 24/7, else? Field name: fapi_main_customer_support',
				'default_value' => 'N/A',
				'placeholder' => 'Ex. 24/7',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5eb3fcf7fbd58',
				'label' => 'Live Chat',
				'name' => 'fapi_main_live_chat',
				'type' => 'radio',
				'choices' => array(
					0 => 'No',
					1 => 'Yes'
				),
				'required' => 1,
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_live_chat',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5hj843e24ce8f',
				'label' => 'Account Opening Score',
				'name' => 'fapi_main_account_score',
				'type' => 'number',
				'instructions' => 'Specify number of account opening score. Field name: fapi_main_account_score',
				'default_value' => '1',
				'placeholder' => 'Ex. 5',
				'prepend' => '',
				'append' => '',
				'min' => '1',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'api_main_9eb3fd42fbd51',
				'label' => 'Deposit and Withdrawal',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_main_5dbb544f4ce91',
				'label' => 'Deposit Type',
				'name' => 'fapi_main_deposit_type',
				'type' => 'text',
				'instructions' => 'Deposit Type. Field name: fapi_main_deposit_type',
				'default_value' => '',
				'placeholder' => 'Specify the deposit type',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5dcr544f4ce91',
				'label' => 'Withdrawal Type',
				'name' => 'fapi_main_withdrawal_type',
				'type' => 'text',
				'instructions' => 'Withdrawal Type. Field name: fapi_main_withdrawal_type',
				'default_value' => '',
				'placeholder' => 'Specify the withdrawal type',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_8eb3fd42fbd59',
				'label' => 'Trading Fees',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_main_5db8594f4ce91',
				'label' => 'Broker Assisted Trades Fee',
				'name' => 'fapi_main_assisted_trades_fee',
				'type' => 'text',
				'instructions' => 'Broker Assisted Trades Fee. Field name: fapi_main_assisted_trades_fee',
				'default_value' => '',
				'placeholder' => 'Broker Assisted Trades Fee',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_main_5eb3fd42fbd59',
				'label' => 'Non-Trading Fees',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_main_5eb3fdb4fbd5c',
				'label' => 'Account Fee',
				'name' => 'fapi_main_account_fee',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_account_fee',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb3fdbffbd5d',
				'label' => 'Inactivity Fees',
				'name' => 'fapi_main_inactivity_fees',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_inactivity_fees',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb3fdccfbd5e',
				'label' => 'Deposit Fee',
				'name' => 'fapi_main_deposit_fee',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_deposit_fee',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb3fddefbd5f',
				'label' => 'Withdrawal Fee',
				'name' => 'fapi_main_withdrawal_fee',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_withdrawal_fee',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb41b611794b',
				'label' => 'Educational Features',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_main_5eb41b6b1794c',
				'label' => 'Demo Account',
				'name' => 'fapi_main_demo_account',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_demo_account',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb41b761794d',
				'label' => 'Platform Tutorial Videos',
				'name' => 'fapi_main_platform_tutorial_videos',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_platform_tutorial_videos',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb41b831794e',
				'label' => 'Educational PDFs',
				'name' => 'fapi_main_educational_pdfs',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_educational_pdfs',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb41b8e1794f',
				'label' => 'Live Webinars',
				'name' => 'fapi_main_live_webinars',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_live_webinars',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb41b9717950',
				'label' => 'YouTube Videos',
				'name' => 'fapi_main_youtube_videos',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_youtube_videos',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb41ba817951',
				'label' => 'Trading Academy',
				'name' => 'fapi_main_trading_academy',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_trading_academy',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_main_5eb41bb517952',
				'label' => 'Trading Glossary',
				'name' => 'fapi_main_trading_glossary',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_main_trading_glossary',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_main',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_stocks post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-stocks-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_stocks_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_stocks_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_stocks_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_stocks_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_stocks_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_stocks_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_stocks_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_stocks_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_stocks_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_stocks_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_stocks_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_stocks_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_stocks_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_stocks_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_stocks_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_stocks_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_stocks_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_stocks_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_stocks_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_stocks_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_stocks_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_stocks_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_stocks_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_stocks_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_stocks_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_stocks_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_stocks_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_stocks_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_stocks_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_stocks_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_stocks_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_stocks_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_stocks_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_stocks_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_stocks_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_stocks_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_stocks_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_stocks_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_stocks_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_stocks_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_stocks_education_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_stocks_5eb3fc5ffbd52',
				'label' => 'Broker Summary',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_stocks_5hj843e24ce8f',
				'label' => 'Number of Stocks',
				'name' => 'fapi_stocks_number',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Specify number of account opening score. Field name: fapi_stocks_number',
				'default_value' => '1',
				'placeholder' => 'Ex. 5',
			),
			array (
				'key' => 'api_stocks_8eb3fd42fbd59',
				'label' => 'Trading Fees',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_stocks_k375jssej5pjw',
				'label' => 'Mutual Fund Fee',
				'name' => 'fapi_stocks_mutual_fund_fee',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Broker Assisted Trades Fee. Field name: fapi_stocks_mutual_fund_fee',
				'default_value' => '',
				'placeholder' => 'Mutual Fund Fee',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_stocks_738m64s52e1ix',
				'label' => 'US Stock Index Options',
				'name' => 'fapi_stocks_us_index_options',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'US Stock Index Options. Field name: fapi_stocks_us_index_options',
				'default_value' => '',
				'placeholder' => 'US Stock Index Options',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_stocks_33sd3ne3vji8u',
				'label' => 'UK Stock Index Options',
				'name' => 'fapi_stocks_uk_index_options',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'UK Stock Index Options. Field name: fapi_stocks_uk_index_options',
				'default_value' => '',
				'placeholder' => 'UK Stock Index Options',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_stocks_x3ydo34y99bww',
				'label' => 'German Stock Index Options',
				'name' => 'fapi_stocks_german_index_options',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'German Stock Index Options. Field name: fapi_stocks_german_index_options',
				'default_value' => '',
				'placeholder' => 'German Stock Index Options',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_stocks_ra09dthvzjos5',
				'label' => 'US Stock Index Futures',
				'name' => 'fapi_stocks_us_index_futures',
				'type' => 'text',
				'instructions' => 'US Stock Index Futures. Field name: fapi_stocks_us_index_futures',
				'default_value' => '',
				'placeholder' => 'US Stock Index Futures',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_stocks_jd5isvesbf447',
				'label' => 'UK Stock Index Futures',
				'name' => 'fapi_stocks_uk_index_futures',
				'type' => 'text',
				'instructions' => 'UK Stock Index Futures. Field name: fapi_stocks_uk_index_futures',
				'default_value' => '',
				'placeholder' => 'UK Stock Index Futures',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_stocks_v23nwbv1qpdo6',
				'label' => 'German Stock Index Futures',
				'name' => 'fapi_stocks_german_index_futures',
				'type' => 'text',
				'instructions' => 'German Stock Index Futures. Field name: fapi_stocks_german_index_futures',
				'default_value' => '',
				'placeholder' => 'German Stock Index Futures',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'api_stocks_5eb3fd42fbd59',
				'label' => 'Stock and ETF Trade Fee',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_stocks_hvboc9y0s0rv1',
				'label' => 'US Stock',
				'name' => 'fapi_stocks_us_stock',
				'type' => 'number',
				'instructions' => 'US Stock. Field name: fapi_stocks_us_stock',
				'default_value' => '',
				'placeholder' => 'Specify the fee',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_stocks_jyekzedjsc7ol',
				'label' => 'UK Stock',
				'name' => 'fapi_stocks_uk_stock',
				'type' => 'number',
				'instructions' => 'UK Stock. Field name: fapi_stocks_uk_stock',
				'default_value' => '',
				'placeholder' => 'Specify the fee',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_stocks_48dx2d1czafki',
				'label' => 'German Stock',
				'name' => 'fapi_stocks_german_stock',
				'type' => 'number',
				'instructions' => 'German Stock. Field name: fapi_stocks_german_stock',
				'default_value' => '',
				'placeholder' => 'Specify the fee',
				'prepend' => '',
				'append' => '',
			),
			array (
				'key' => 'api_stocks_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_stocks_5eb41af317944',
				'label' => 'News',
				'name' => 'fapi_stocks_news',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_stocks_news',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_stocks_5eb41b1317945',
				'label' => 'Trading Signals and Indicators',
				'name' => 'fapi_stocks_trading_signals_and_indicators',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_stocks_trading_signals_and_indicators',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_stocks_5eb41b2717946',
				'label' => 'Trade Ideas',
				'name' => 'fapi_stocks_trade_ideas',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_stocks_trade_ideas',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_stocks_5eb41b3017947',
				'label' => 'Expert Analysis',
				'name' => 'fapi_stocks_expert_analysis',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_stocks_expert_analysis',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_stocks_5eb41b4c17949',
				'label' => 'Sentiment Charts',
				'name' => 'fapi_stocks_sentiment_charts',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_stocks_sentiment_charts',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_stocks_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fapi_stocks_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_stocks_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
            array (
				'key' => 'api_stocks_ahuu411gh3ote',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_stocks_ovugb2p8swhop',
				'label' => 'Number of Options',
				'name' => 'fapi_stocks_options_number',
				'type' => 'number',
				'instructions'   => 'Specify number of options. Field name: fapi_stocks_options_number',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_stocks_xryauw4z6ghi2',
				'label' => 'Number of Stocks and Shares',
				'name' => 'fapi_stocks_shares_number',
				'type' => 'number',
				'instructions'   => 'Specify number of stocks and shares. Field name: fapi_stocks_shares_number',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_stocks_4xu0axbrqli1r',
				'label' => 'Number of ETFs',
				'name' => 'fapi_stocks_etfs_number',
				'type' => 'number',
				'instructions'   => 'Specify number of ETFs. Field name: fapi_stocks_etfs_number',
				'message' => '',
				'default_value' => 0,
            ),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_stocks',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_cfd post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-cfd-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_cfd_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_cfd_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_cfd_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_cfd_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_cfd_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_cfd_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_cfd_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_cfd_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_cfd_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_cfd_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_cfd_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_cfd_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_cfd_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_cfd_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_cfd_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_cfd_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_cfd_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_cfd_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_cfd_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_cfd_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_cfd_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_cfd_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_cfd_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_cfd_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_cfd_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_cfd_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_cfd_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_cfd_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_cfd_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_cfd_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_cfd_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_cfd_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_cfd_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_cfd_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_cfd_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_cfd_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_cfd_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_cfd_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_cfd_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_cfd_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_cfd_education_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_cfd_5eb3fc5ffbd52',
				'label' => 'Broker Summary',
				'name' => '',
				'type' => 'tab',
            ),
			array (
				'key' => 'api_cfd_to2il0entw1uv',
				'label' => 'MT4',
				'name' => 'fapi_cfd_mt4',
				'type' => 'radio',
				'choices' => array(
					0 => 'No',
					1 => 'Yes'
				),
				'required' => 1,
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_cfd_mt4',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_cfd_ga0hs46n9msoj',
				'label' => 'MT5',
				'name' => 'fapi_cfd_mt5',
				'type' => 'radio',
				'choices' => array(
					0 => 'No',
					1 => 'Yes'
				),
				'required' => 1,
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_cfd_mt5',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_cfd_8xkpgncal0tkq',
				'label' => 'CFD Fees',
				'name' => 'fapi_cfd_fee',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'CFD Fees. Field name: fapi_cfd_fee',
				'default_value' => '',
				'placeholder' => 'CFD Fees',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
			array (
				'key' => 'api_cfd_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_cfd_5eb41b1317945',
				'label' => 'Trading Signals and Indicators',
				'name' => 'fapi_cfd_trading_signals_and_indicators',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_cfd_trading_signals_and_indicators',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_cfd_5eb41b3017947',
				'label' => 'Expert Analysis',
				'name' => 'fapi_cfd_expert_analysis',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_cfd_expert_analysis',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_cfd_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fapi_cfd_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_cfd_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
            array (
				'key' => 'api_cfd_ahuu411gh3ote',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_cfd_ovugb2p8swhop',
				'label' => 'Number of Indices',
				'name' => 'fapi_cfd_indices_number',
				'type' => 'number',
				'instructions'   => 'Specify number of indices. Field name: fapi_cfd_indices_number',
				'message' => '',
				'default_value' => 0,
            ),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_cfd',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_forex post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-forex-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_forex_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_forex_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_forex_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_forex_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_forex_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_forex_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_forex_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_forex_59ef232d0245f',
				'label'         => 'Brokers Review Link TRFB (TopRatedForexBrokers.com)',
				'name'          => 'fapi_forex_review_trfb',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the broker\'s review url as:  http://www.example.com. Field name: fapi_forex_review_trfb',
				'placeholder'   => 'http://www.example.com',
				'prepend'       => '',
				'append'        => '',
				'formatting'    => 'html',
				'maxlength'     => '',
			),
			array(
				'key'           => 'api_forex_59ef232d0245g',
				'label'         => 'Brokers Review Link TOFB (TopOnlineForexBrokers.com)',
				'name'          => 'fapi_forex_review_tofb',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the broker\'s review url as:  http://www.example.com. Field name: fapi_forex_review_tofb',
				'placeholder'   => 'http://www.example.com',
				'prepend'       => '',
				'append'        => '',
				'formatting'    => 'html',
				'maxlength'     => '',
			),
			array(
				'key'           => 'api_forex_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_forex_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_forex_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_forex_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_forex_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_forex_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_forex_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_forex_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_forex_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_forex_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_forex_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_forex_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_forex_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_forex_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_forex_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_forex_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_forex_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_forex_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_forex_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_forex_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_forex_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_forex_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_forex_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_forex_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_forex_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_forex_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_forex_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_forex_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_forex_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_forex_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_forex_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_forex_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_forex_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_forex_education_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_forex_5eb3fc5ffbd52',
				'label' => 'Broker Summary',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_forex_gaxiggcs0fv5f',
				'label' => 'Maximum Leverage',
				'name' => 'fapi_forex_max_leverage',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Maximum Leverage. Field name: fapi_forex_max_leverage',
				'default_value' => '',
				'placeholder' => 'Maximum Leverage',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_forex_to2il0entw1uv',
				'label' => 'MT4',
				'name' => 'fapi_forex_mt4',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_mt4',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_forex_ga0hs46n9msoj',
				'label' => 'MT5',
				'name' => 'fapi_forex_mt5',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_mt5',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_forex_8eb3fd42fbd59',
				'label' => 'Trading Fees',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_forex_r4ir8hc0z6dgc',
				'label' => 'Forex Fees',
				'name' => 'fapi_forex_fees',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Forex Fees. Field name: fapi_forex_fees',
				'default_value' => '',
				'placeholder' => 'Forex Fees',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_forex_uam6kel87mx7u',
				'label' => 'Min Spread EUR/USD',
				'name' => 'fapi_forex_min_spread',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 15',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of pips. Field name: fapi_forex_min_spread',
				'min' => '0',
				'max' => '',
            ),
            array (
				'key' => 'api_forex_ic4mfwf0a6a0p',
				'label' => 'Commission',
				'name' => 'fapi_forex_commission',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 15',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify commission (%). Field name: fapi_forex_commission',
				'min' => '0',
				'max' => '',
            ),
            array (
				'key' => 'api_forex_30lfyj9x88z5m',
				'label' => 'Commission on Islamic Accounts',
				'name' => 'fapi_forex_commission_islamic',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 15',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify commission (%). Field name: fapi_forex_commission_islamic',
				'min' => '0',
				'max' => '',
			),
			array (
				'key' => 'api_forex_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_forex_5eb41af317944',
				'label' => 'News',
				'name' => 'fapi_forex_news',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_news',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_forex_5eb41b1317945',
				'label' => 'Trading Signals and Indicators',
				'name' => 'fapi_forex_trading_signals_and_indicators',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_trading_signals_and_indicators',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_forex_5eb41b2717946',
				'label' => 'Trade Ideas',
				'name' => 'fapi_forex_trade_ideas',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_trade_ideas',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_forex_5eb41b3017947',
				'label' => 'Expert Analysis',
				'name' => 'fapi_forex_expert_analysis',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_expert_analysis',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_forex_5eb41b3e17948',
				'label' => 'Autochartist Tools',
				'name' => 'fapi_forex_autochartist_tools',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_autochartist_tools',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_forex_5eb41b4c17949',
				'label' => 'Sentiment Charts',
				'name' => 'fapi_forex_sentiment_charts',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_sentiment_charts',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_forex_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fapi_forex_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_forex_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
            array (
				'key' => 'api_forex_ahuu411gh3ote',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_forex_ovugb2p8swhop',
				'label' => 'Currency Pairs',
				'name' => 'fapi_forex_currency_pairs',
				'type' => 'number',
				'required' => 1,
				'instructions'   => 'Specify number of currency pairs. Field name: fapi_forex_currency_pairs',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_forex_l5texii2wtp3h',
				'label' => 'Number of Precious Metals',
				'name' => 'fapi_forex_precious_metals',
				'type' => 'number',
				'instructions'   => 'Specify number of precious metals. Field name: fapi_forex_precious_metals',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_forex_p80zhl8bnxws2',
				'label' => 'Number of ETFs',
				'name' => 'fapi_forex_etfs',
				'type' => 'number',
				'instructions'   => 'Specify number of ETFs. Field name: fapi_forex_etfs',
				'message' => '',
				'default_value' => 0,
            ),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_forex',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_crypto post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-crypto-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_crypto_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_crypto_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_crypto_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_crypto_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_crypto_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_crypto_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_crypto_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_crypto_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_crypto_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_crypto_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_crypto_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_crypto_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_crypto_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_crypto_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_crypto_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_crypto_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_crypto_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_crypto_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_crypto_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_crypto_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_crypto_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_crypto_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_crypto_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_crypto_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_crypto_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_crypto_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_crypto_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_crypto_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_crypto_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_crypto_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_crypto_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_crypto_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_crypto_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_crypto_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_crypto_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_crypto_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_crypto_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_crypto_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_crypto_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_crypto_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_crypto_education_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_crypto_5eb3fc5ffbd52',
				'label' => 'Broker Summary',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_crypto_gaxiggcs0fv5f',
				'label' => 'Number of Cryptocurrencies',
				'name' => 'fapi_crypto_number_str',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Number of Cryptocurrencies. Field name: fapi_crypto_number_str',
				'default_value' => '',
				'placeholder' => 'Number of Cryptocurrencies',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
			array (
				'key' => 'api_crypto_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_crypto_5eb41af317944',
				'label' => 'News',
				'name' => 'fapi_crypto_news',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_crypto_news',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_crypto_5eb41b1317945',
				'label' => 'Trading Signals and Indicators',
				'name' => 'fapi_crypto_trading_signals_and_indicators',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_crypto_trading_signals_and_indicators',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_crypto_5eb41b3017947',
				'label' => 'Expert Analysis',
				'name' => 'fapi_crypto_expert_analysis',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_crypto_expert_analysis',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_crypto_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fapi_crypto_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_crypto_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_crypto',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_commodities post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-commodities-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_commodities_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_commodities_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_commodities_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_commodities_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_commodities_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_commodities_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_commodities_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_commodities_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_commodities_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_commodities_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_commodities_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_commodities_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_commodities_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_commodities_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_commodities_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_commodities_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_commodities_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_commodities_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_commodities_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_commodities_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_commodities_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_commodities_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_commodities_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_commodities_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_commodities_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_commodities_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_commodities_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_commodities_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_commodities_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_commodities_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_commodities_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_commodities_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_commodities_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_commodities_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_commodities_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_commodities_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_commodities_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_commodities_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_commodities_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_commodities_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_commodities_education_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_commodities_5eb3fc5ffbd52',
				'label' => 'Broker Summary',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_commodities_to2il0entw1uv',
				'label' => 'MT4',
				'name' => 'fapi_commodities_mt4',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_commodities_mt4',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_commodities_ga0hs46n9msoj',
				'label' => 'MT5',
				'name' => 'fapi_commodities_mt5',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_commodities_mt5',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_commodities_8eb3fd42fbd59',
				'label' => 'Trading Fees',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_commodities_r4ir8hc0z6dgc',
				'label' => 'Mutual Fund Fee',
				'name' => 'fapi_commodities_mutual_fund_fee',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Mutual Fund Fee. Field name: fapi_commodities_mutual_fund_fee',
				'default_value' => '',
				'placeholder' => 'Mutual Fund Fee',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
			array (
				'key' => 'api_commodities_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_commodities_5eb41af317944',
				'label' => 'News',
				'name' => 'fapi_commodities_news',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_commodities_news',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_commodities_5eb41b1317945',
				'label' => 'Trading Signals and Indicators',
				'name' => 'fapi_commodities_trading_signals_and_indicators',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_commodities_trading_signals_and_indicators',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_commodities_5eb41b3017947',
				'label' => 'Expert Analysis',
				'name' => 'fapi_commodities_expert_analysis',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_commodities_expert_analysis',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_commodities_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fapi_commodities_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_commodities_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
            array (
				'key' => 'api_commodities_ahuu411gh3ote',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_commodities_ovugb2p8swhop',
				'label' => 'Number of Commodities',
				'name' => 'fapi_commodities_number',
				'type' => 'number',
				'instructions'   => 'Specify number of commodities. Field name: fapi_commodities_number',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_commodities_o3kz7ux5s6f5f',
				'label' => 'Number of Precious Metals',
				'name' => 'fapi_commodities_precious_metals',
				'type' => 'number',
				'instructions'   => 'Specify number of precious metals. Field name: fapi_commodities_precious_metals',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_commodities_fawukdgofaqbm',
				'label' => 'Number of ETFs',
				'name' => 'fapi_commodities_etfs',
				'type' => 'number',
				'instructions'   => 'Specify number of ETFs. Field name: fapi_commodities_etfs',
				'message' => '',
				'default_value' => 0,
            ),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_comm',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_discount post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-discount-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_discount_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_discount_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_discount_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_discount_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_discount_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_discount_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_discount_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_discount_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_discount_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_discount_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_discount_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_discount_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_discount_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_discount_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_discount_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_discount_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_discount_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_discount_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_discount_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_discount_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_discount_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_discount_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_discount_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_discount_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_discount_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_discount_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_discount_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_discount_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_discount_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_discount_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_discount_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_discount_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_discount_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_discount_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_discount_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_discount_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_discount_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_discount_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_discount_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_discount_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_discount_education_score',
				'min' => '0',
				'max' => '99',
			),
            array (
				'key' => 'api_discount_ahuu411gh3ote',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_discount_ovugb2p8swhop',
				'label' => 'Number of Options',
				'name' => 'fapi_discount_options',
				'type' => 'number',
				'instructions'   => 'Specify number of options. Field name: fapi_discount_options',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_discount_o3kz7ux5s6f5f',
				'label' => 'Number of Stocks and Shares',
				'name' => 'fapi_discount_stocks_shares',
				'type' => 'number',
				'instructions'   => 'Specify number of stocks and shares. Field name: fapi_discount_stocks_shares',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_discount_fawukdgofaqbm',
				'label' => 'Number of Cryptocurrencies',
				'name' => 'fapi_discount_cryptocurrencies',
				'type' => 'number',
				'instructions'   => 'Specify number of cryptocurrencies. Field name: fapi_discount_cryptocurrencies',
				'message' => '',
				'default_value' => 0,
            ),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_discount',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_social post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-social-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_social_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_social_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_social_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_social_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_social_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_social_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_social_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_social_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_social_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_social_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_social_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_social_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_social_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_social_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_social_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_social_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_social_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_social_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_social_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_social_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_social_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_social_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_social_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_social_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_social_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_social_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_social_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_social_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_social_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_social_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_social_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_social_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_social_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_social_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_social_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_social_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_social_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_social_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_social_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_social_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_social_education_score',
				'min' => '0',
				'max' => '99',
			),
            array (
				'key' => 'api_social_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_social_5eb41af317944',
				'label' => 'News',
				'name' => 'fapi_social_news',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_social_news',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_social_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fapi_social_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_social_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_social',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

// Register fields for finance_api_bonds post type
if ( function_exists( "register_field_group" ) ) {
	register_field_group( array(
		'id'         => 'finance-api-bonds-details',
		'title'      => 'Broker Details',
		'fields'     => array(
			array (
				'key' => 'api_bonds_6fc3fb94fbd4b',
				'label' => 'Main Information',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_bonds_f6c3fca1fbd55',
				'label' => 'Main broker',
				'name' => 'fapi_bonds_main',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_bonds_main',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_bonds_f6c3bhr1fbd55',
				'label' => 'Non-recommended broker',
				'name' => 'fapi_bonds_nonrecommended',
				'type' => 'true_false',
				'instructions'   => 'Check for Yes, leave blank for No. Field name: fapi_bonds_nonrecommended',
				'message' => '',
				'default_value' => 0,
			),
			array(
				'key'           => 'api_bonds_59ef213c8cb87',
				'label'         => 'Welcome Bonus',
				'name'          => 'fapi_bonds_welcome_bonus',
				'type'          => 'text',
				'default_value' => 'No Information',
				'instructions'   => 'Please insert the welcome bonus. Field name: fapi_bonds_welcome_bonus',
				'placeholder'   => 'ex. 100% up to $1,000',
			),
			array(
				'key'           => 'api_bonds_59jb513c8cb87',
				'label'         => 'Bonus Tooltip',
				'name'          => 'fapi_bonds_bonus_tooltip',
				'type'          => 'text',
				'default_value' => '',
				'instructions'   => 'Please insert the welcome bonus tooltip if it is needed. Field name: fapi_bonds_welcome_bonus_tooltip',
				'placeholder'   => 'ex. "Applies to X and Y"',
			),
			array (
				'key' => 'api_bonds_5db843e24cg94',
				'label' => 'Hidden Points rating',
				'name' => 'fapi_bonds_hidden_points_rating',
				'type' => 'number',
				'instructions' => 'Specify number of points rating (0-99). This will be used to determine brokers order in tables. Field name: fapi_bonds_hidden_points_rating',
				'default_value' => 50,
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'min' => '0',
				'max' => '99',
				'step' => '',
			),
			array (
				'key' => 'api_bonds_5eb3fb94fbd4b',
				'label' => 'Review score',
				'name' => '',
				'type' => 'tab',
            ),
            array(
				'key'               => 'api_bonds_59ef227967fae',
				'label'             => 'Rating',
				'name'              => 'fapi_bonds_rating',
				'type'              => 'radio',
				'required' => 1,
				'choices'           => array(
					1 => '1 star',
					2 => '2 star',
					3 => '3 star',
					4 => '4 star',
					5 => '5 star',
				),

				'instructions'   => 'Please choose your rating value. Field name: fapi_bonds_rating',
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
			),
			array (
				'key' => 'api_bonds_63f3fbc2fbd4c',
				'label' => 'Points rating',
				'name' => 'fapi_bonds_points_rating',
				'type' => 'number',
				'required' => 1,
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_bonds_points_rating',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_bonds_5eb3fbc2fbd4c',
				'label' => 'Commissions & Fees',
				'name' => 'fapi_bonds_commissions_and_fees_score',
				'type' => 'number',
				'default_value' => '50',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_bonds_commissions_and_fees_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_bonds_5eb3fbe8fbd4d',
				'label' => 'Licensing & Safety',
				'name' => 'fapi_bonds_licensing_and_safety_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_bonds_licensing_and_safety_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_bonds_5eb3fbf9fbd4e',
				'label' => 'Trading Platforms & Tools',
				'name' => 'fapi_bonds_trading_platforms_and_tools_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_bonds_trading_platforms_and_tools_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_bonds_5eb3fc09fbd4f',
				'label' => 'Payments',
				'name' => 'fapi_bonds_payments_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_bonds_payments_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_bonds_5eb3fc2ffbd50',
				'label' => 'Customer Service',
				'name' => 'fapi_bonds_customer_service_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_bonds_customer_service_score',
				'min' => '0',
				'max' => '99',
			),
			array (
				'key' => 'api_bonds_5eb3fc3bfbd51',
				'label' => 'Education',
				'name' => 'fapi_bonds_education_score',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => 'Ex. 95',
				'prepend' => '',
				'append' => '',
				'instructions' => 'Specify number of points rating (0-99). Field name: fapi_bonds_education_score',
				'min' => '0',
				'max' => '99',
            ),
            array (
				'key' => 'api_bonds_8eb3fd42fbd59',
				'label' => 'Trading Fees',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_bonds_r4ir8hc0z6dgc',
				'label' => 'Mutual Fund Fees',
				'name' => 'fapi_bonds_mutual_fund_fee',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'Forex Fees. Field name: fapi_bonds_mutual_fund_fee',
				'default_value' => '',
				'placeholder' => 'Mutual Fund Fees',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_bonds_y1fw8majke2gf',
				'label' => 'US Treasury Bond',
				'name' => 'fapi_bonds_us_treasury_bond',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'US Treasury Bond. Field name: fapi_bonds_us_treasury_bond',
				'default_value' => '',
				'placeholder' => 'US Treasury Bond',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_bonds_yzz48qcvx3i2w',
				'label' => 'EU Government Bond',
				'name' => 'fapi_bonds_eu_government_bond',
				'type' => 'text',
				'required' => 1,
				'instructions' => 'EU Government Bond. Field name: fapi_bonds_eu_government_bond',
				'default_value' => '',
				'placeholder' => 'EU Government Bond',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
            ),
            array (
				'key' => 'api_bonds_ahuu411gh3ote',
				'label' => 'Markets and Products',
				'name' => '',
				'type' => 'tab',
            ),
            array (
				'key' => 'api_bonds_ovugb2p8swhop',
				'label' => 'Number of Options',
				'name' => 'fapi_bonds_options',
				'type' => 'number',
				'instructions'   => 'Specify number of options. Field name: fapi_bonds_options',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_bonds_o3kz7ux5s6f5f',
				'label' => 'Number of Stocks and Shares',
				'name' => 'fapi_bonds_stocks_shares',
				'type' => 'number',
				'instructions'   => 'Specify number of stocks and shares. Field name: fapi_bonds_stocks_shares',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_bonds_fawukdgofaqbm',
				'label' => 'Number of ETFs',
				'name' => 'fapi_bonds_etfs',
				'type' => 'number',
				'instructions'   => 'Specify number of ETFs. Field name: fapi_bonds_etfs',
				'message' => '',
				'default_value' => 0,
            ),
            array (
				'key' => 'api_bonds_5eb3feeffbd67',
				'label' => 'Research Tools',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'api_bonds_5eb41af317944',
				'label' => 'News',
				'name' => 'fapi_bonds_news',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_bonds_news',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_bonds_5eb41b1317945',
				'label' => 'Trading Signals and Indicators',
				'name' => 'fapi_bonds_trading_signals_and_indicators',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_bonds_trading_signals_and_indicators',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_bonds_5eb41b2717946',
				'label' => 'Trade Ideas',
				'name' => 'fapi_bonds_trade_ideas',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_bonds_trade_ideas',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_bonds_5eb41b3017947',
				'label' => 'Expert Analysis',
				'name' => 'fapi_bonds_expert_analysis',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_bonds_expert_analysis',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'api_bonds_5eb41b561794a',
				'label' => 'Economic Calendar',
				'name' => 'fapi_bonds_economic_calendar',
				'type' => 'true_false',
				'instructions' => 'Check for Yes, leave blank for No. Field name: fapi_bonds_economic_calendar',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location'   => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'finance_api_bonds',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options'    => array(
			'position'       => 'normal',
			'layout'         => 'no_box',
			'hide_on_screen' => array(),
		),
		'menu_order' => 0,
	) );
}

}

/* Make Broker name as default post title*/
public function my_post_title_updater( $post_id ) {

	if (get_post_type( $post_id ) == "fln_broker") {

		$my_post = array();
		$my_post['ID'] = $post_id;
		$my_post['post_title'] = get_field( 'fln_broker_name', $post_id );

		// Update the post into the database
		wp_update_post( $my_post );
	}

}
//Terms categories CURRENTLY NOT USED because of refusing to use global variables needs to be refactored
public function table_term_slug() {
	global $post;
	$terms = get_the_terms( $post->ID, 'table_cat' );
	 if ( !empty( $terms ) ){
		 // get the first term
		 $term = array_shift( $terms );
		 $term_slug =  $term->slug;
	 }
	 return $term_slug;
}


/*Reveal shortcode column*/
public function revealid_add_shortcode_column( $columns ) {
   $columns['revealid_id'] = 'ID';
   return $columns;
}
/*Reveal shortcode column lists*/
public function revealid_shortcode_column_content( $column, $id ) {
	global $post;
	$terms = get_the_terms( $post->ID, 'table_cat' );
	if ( !empty( $terms ) ){
		// get the first term
	 // $term = array_shift( $terms );
		foreach( $terms as $term ) {
				$terms_slugs[] = $term->slug; // save the slugs in an array
				$term_slug =  implode( ', ', $terms_slugs );

					var_dump(get_term_by('id', $post->ID, 'table_cat'));
		}
	}

  if( 'revealid_id' == $column ) {
	  echo '[financial-table table_id="'. $id.'" title="" next_link="" next_link_name="" category="' . $term_slug . '" class="" tracker_suffix=""]';
	  // Empty class added to let user know he can specify table class.
  }
}




 /* Create a meta box for our custom fields */
 public function rerender_meta_options() {
     add_meta_box('customer-meta', 'Table Shortcode', array($this, 'dispaly_meta_options'), 'fln_table', 'side', 'high');
 }
 // Display meta box and custom fields
 public function dispaly_meta_options( $post_id) {
     global $post;

		 $terms = get_the_terms( $post->ID, 'table_cat' );

			if ( !empty( $terms ) ){
		    // get the first term
		   // $term = array_shift( $terms );
				foreach( $terms as $term ) {
				    $terms_slugs[] = $term->slug; // save the slugs in an array
						$term_slug =  implode( ', ', $terms_slugs );

					//	var_dump($terms_slugs);
				}
		    //$term_slug =  $term->slug;


			}
     ?>
	 <?php 	echo '[financial-table table_id="'.  $post->ID .'" title="" next_link="" next_link_name="" category="' . $term_slug . '" class="" tracker_suffix=""]' ;
	 	  // Empty class added to let user know he can specify table class.
 }
}
